package java.game.cars;

import java.util.*;
import java.util.resource.*;
import java.game.parts.bodypart.*;


public class Sunset_trunk extends Trunk
{
	public Sunset_trunk( int id )
	{
		super( id );
		carCategory = PACKAGE;
		name = "Sunset trunk";

		value = 375;
	}
	
	public void addStockParts( int actcolor, float optical, float power )
	{
		super.addStockParts( actcolor, optical, power );

		randomize( optical + power );

		// parts that have only one appearance //
		if ( optical >= 1.0 )
		{
			addPart( cars.cat_03.sunset:0x00000106r, "L taillights", actcolor, optical, power );
			addPart( cars.cat_03.sunset:0x00000111r, "R taillights", actcolor, optical, power );
		} else
		{
			if ( optical >= random() ) addPart( cars.cat_03.sunset:0x00000106r, "L taillights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_03.sunset:0x00000111r, "R taillights", actcolor, optical, power );
		}

		// parts that have multiple appearance //
		if ( optical > 1.0 )
		{
			float part_random = random();
			if ( part_random >= 0.5 ) addPart( cars.cat_03.sunset:0x000000FCr, "R wing 3", actcolor, optical, power ); else
			addPart( cars.cat_03.sunset:0x000000F3r, "R wing 2", actcolor, optical, power );
		}
	}
}
